/*
 *  kexbasen\shell32\_shell32_apilist.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2016, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
#include "kexcoresdk.h"
#include "_shell32_apilist.h"

extern void uninit_SHGetFolderPath();

BOOL init_shell32()
{
	return TRUE;
}

BOOL init_shfolder()
{
	return TRUE;
}

void uninit_shell32()
{
	uninit_SHGetFolderPath();
}

static const apilib_named_api shell32_named_apis[] = 
{
/*** AUTOGENERATED APILIST NAMED EXPORTS BEGIN ***/
	DECL_API("DragQueryFileW", DragQueryFileW_new),
	DECL_API("ExtractIconExW", ExtractIconExW_fwd),
	DECL_API("ExtractIconW", ExtractIconW_fwd),
	DECL_API("FindExecutableW", FindExecutableW_fwd),
	DECL_API("SHBindToParent", SHBindToParent_new),
	DECL_API("SHBrowseForFolderW", SHBrowseForFolderW_fwd),
	DECL_API("SHCreateDirectoryExA", SHCreateDirectoryExA_new),
	DECL_API("SHCreateDirectoryExW", SHCreateDirectoryExW_new),
	DECL_API("SHFileOperationW", SHFileOperationW_fwd),
	DECL_API("SHGetFileInfoW", SHGetFileInfoW_fwd),
	DECL_API("SHGetFolderLocation", SHGetFolderLocation_new),
	DECL_API("SHGetFolderPathA", SHGetFolderPathA_fix),
	DECL_API("SHGetFolderPathAndSubDirA", SHGetFolderPathAndSubDirA_xp),
	DECL_API("SHGetFolderPathAndSubDirW", SHGetFolderPathAndSubDirW_xp),
	DECL_API("SHGetFolderPathW", SHGetFolderPathW_fix),
	DECL_API("SHGetNewLinkInfoW", SHGetNewLinkInfoW_fwd),
	DECL_API("SHGetSpecialFolderLocation", SHGetSpecialFolderLocation_fix),
	DECL_API("SHGetSpecialFolderPathA", SHGetSpecialFolderPathA_new),
	DECL_API("SHGetSpecialFolderPathW", SHGetSpecialFolderPathW_new),
	DECL_API("SHParseDisplayName", SHParseDisplayName_new),
	DECL_API("ShellAboutW", ShellAboutW_fwd),
	DECL_API("ShellExecuteExW", ShellExecuteExW_fwd),
	DECL_API("ShellExecuteW", ShellExecuteW_fwd),
	DECL_API("Shell_NotifyIconW", Shell_NotifyIconW_fwd),
	DECL_API("StrChrA", StrChrA_fwd),
	DECL_API("StrChrW", StrChrW_fwd),
	DECL_API("StrRStrIA", StrRStrIA_fwd),
/*** AUTOGENERATED APILIST NAMED EXPORTS END ***/
};

#ifndef shell32_ordinal_apis
static const apilib_unnamed_api shell32_ordinal_apis[] =
{
/*** AUTOGENERATED APILIST ORDINAL EXPORTS BEGIN ***/
/*** AUTOGENERATED APILIST ORDINAL EXPORTS END ***/
};
#endif

const apilib_api_table apitable_shell32 = 
  DECL_TAB("SHELL32.DLL", shell32_named_apis, shell32_ordinal_apis);


/*** Also use SHFOLDER_SHGetFolderPath fixes for Shfolder.dll ***/
static const apilib_named_api shfolder_named_apis[] = 
{
	DECL_API("SHGetFolderPathA", SHGetFolderPathA_fix),
	DECL_API("SHGetFolderPathW", SHGetFolderPathW_fix),
};
const apilib_api_table apitable_shfolder = 
  DECL_TAB("SHFOLDER.DLL", shfolder_named_apis, NULL);
